<x-layout-dashboard title="{{__('Themes Manager')}}">
	<!--breadcrumb-->
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb breadcrumb-custom-icon">
			<li class="breadcrumb-item">
				<a href="javascript:void(0);">{{__('Admin')}}</a>
				<i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
			</li>
			<li class="breadcrumb-item active">{{__('Themes Manager')}}</li>
		</ol>
	</nav>
	<!--end breadcrumb-->
	@if (session()->has('alert'))
        <x-alert>
            @slot('type', session('alert')['type'])
            @slot('msg', session('alert')['msg'])
        </x-alert>
    @endif
    @if ($errors->any())
		<div class="alert alert-danger alert-dismissible" role="alert">
			<h4 class="alert-heading d-flex align-items-center">
				<span class="alert-icon rounded">
					<i class="icon-base ti tabler-face-id-error icon-md"></i>
				</span>
				{{__('Oh Error :(')}}
			</h4>
			<hr>
			<p class="mb-0">
				<p>{{__('The given data was invalid.')}}</p>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
			</p>
			<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
		</div>
    @endif
<div class="card mb-4">
	<div class="card-header d-flex justify-content-between">
		<h5 class="card-title">{{__('Installed Themes')}}</h5>
	</div>
	<div class="container mt-3">
		@if(session('status'))
			<div class="alert alert-success">
				{{ session('status') }}
			</div>
		@endif
		<div class="themes">
			<div class="row mb-5">
				@foreach($themes as $theme)
					<div class="col-md-4 mb-4">
						<div class="card shadow-sm h-100 border">
							<img src="{{ $theme['screenshot'] }}" class="card-img-top theme-img cursor-pointer border-bottom" alt="{{ $theme['name'] }}" data-bs-toggle="modal" data-bs-target="#themeModal" data-img="{{ $theme['screenshot'] }}">
							<div class="card-body text-center">
								<h5 class="card-title">{{ $theme['name'] }}</h5>
								<p class="card-text">{{__('Version:')}} {{ $theme['version'] }}</p>
								<p class="card-text">{{__('Author:')}} {{ $theme['author'] }}</p>
								<div class="d-flex flex-wrap justify-content-center gap-2 mt-3">
									@if ($theme['folder'] != env('THEME_NAME') && $theme['folder'] != 'veuxy')
										<form method="POST" action="{{ route('themes.delete') }}" onsubmit="return confirm('{{__('Are you sure will delete this theme?')}}')">
											@csrf
											<input type="hidden" name="folder" value="{{ $theme['folder'] }}">
											<button type="submit" class="badge bg-danger-subtle text-danger btn-sm d-flex align-items-center justify-content-center px-3" style="min-width: 40px;height: 100%;">
												<i class="ti tabler-trash"></i>
											</button>
										</form>
									@else
										<button class="badge bg-danger-subtle text-danger btn-sm d-flex align-items-center justify-content-center px-3" style="min-width: 40px;" disabled>
											<i class="ti tabler-trash"></i>
										</button>
									@endif

									@if ($theme['website'] != '')
										<a href="{{ $theme['website'] }}" target="_blank" class="badge bg-primary-subtle text-primary btn-sm d-flex align-items-center px-3">
											<i class="ti tabler-external-link me-1"></i> {{__('Visit')}}
										</a>
									@endif
									
									@if (!in_array($currentVersion, $theme['compatibility']))
										<button class="badge bg-danger-subtle text-danger btn-sm d-flex align-items-center px-3" disabled>
											<i class="ti tabler-x me-1"></i> {{__('Not compatible')}}
										</button>
									@else
										@if ($theme['folder'] == env('THEME_NAME'))
											<button class="badge bg-dark-subtle text-dark btn-sm d-flex align-items-center px-3" disabled>
												<i class="ti tabler-check me-1"></i> {{__('Activated')}}
											</button>
										@else
											<a href="{{ route('themes.active', $theme['folder']) }}" class="badge bg-success-subtle text-success btn-sm d-flex align-items-center px-3">
												<i class="ti tabler-rocket me-1"></i> {{__('Activate')}}
											</a>
										@endif
									@endif
								</div>
							</div>
						</div>
					</div>
				@endforeach
			</div>
		</div>
	</div>
</div>

<div class="card">
	<div class="card-header d-flex justify-content-between">
		<h5 class="card-title">{{__('Online Themes')}}</h5>
	</div>
	<div class="container mt-3">
		<div class="themes">
			<div class="row mb-5">
				@foreach($onlines as $onlone)
					<div class="col-md-4 mb-4">
						<div class="card shadow-sm h-100 border">
							<img src="{{ $onlone['screenshot'] }}" class="card-img-top theme-img cursor-pointer border-bottom" alt="{{ $onlone['name'] }}" data-bs-toggle="modal" data-bs-target="#themeModal" data-img="{{ $onlone['screenshot'] }}">
							<div class="card-body text-center">
								<h5 class="card-title">{{ $onlone['name'] }}</h5>
								<p class="card-text">{{__('Version:')}} {{ $onlone['version'] }}</p>
								<p class="card-text">{{__('Author:')}} {{ $onlone['author'] }}</p>
								<p class="card-text">
									{{__('Compatibility:')}}
									@if (in_array($currentVersion, $onlone['compatibility']))
										<span class="text-success">{{__('Yes')}}</span>
									@else
										<span class="text-danger">{{__('No')}}</span>
									@endif
								</p>
								<div class="d-flex justify-content-center flex-wrap gap-2 mt-3">
									@if ($onlone['demo'] == "")
										<button class="badge btn-sm bg-primary-subtle text-primary d-flex align-items-center px-3" data-bs-toggle="modal" data-bs-target="#themeModal" data-img="{{ $onlone['screenshot'] }}">
											<i class="ti tabler-eye me-1"></i> {{__('Demo')}}
										</button>
									@else
										<a href="{{ $onlone['demo'] }}" target="_blank" class="badge btn-sm bg-primary-subtle text-primary d-flex align-items-center px-3">
											<i class="ti tabler-eye me-1"></i> {{__('Demo')}}
										</a>
									@endif

									@if (in_array($currentVersion, $onlone['compatibility']))
										@if ($onlone['folder'] != env('THEME_NAME'))
											<form method="POST" action="{{ route('themes.download') }}">
												@csrf
												<input type="hidden" name="download" value="{{ $onlone['download'] }}">
												<input type="hidden" name="folder" value="{{ $onlone['folder'] }}">
												<button type="submit" class="badge btn-sm bg-success-subtle text-success d-flex align-items-center px-3">
													<i class="ti tabler-download me-1"></i> {{__('Download & Active')}}
												</button>
											</form>
										@else
											<button class="badge btn-sm bg-dark-subtle text-dark d-flex align-items-center px-3" disabled>
												<i class="ti tabler-check me-1"></i> {{__('Activated')}}
											</button>
										@endif
									@else
										<button class="badge btn-sm bg-danger-subtle text-danger d-flex align-items-center px-3" disabled>
											<i class="ti tabler-x me-1"></i> {{__('Not compatible')}}
										</button>
									@endif
								</div>
							</div>
						</div>
					</div>
				@endforeach
			</div>
		</div>
	</div>
</div>

<!-- Modal -->
<div class="modal fade" id="themeModal" tabindex="-1" aria-labelledby="themeModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="themeModalLabel">{{__('Theme Preview')}}</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body text-center">
				<img src="" id="theme-modal-img" class="img-fluid" alt="{{__('Theme Preview')}}">
			</div>
		</div>
	</div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
	var themeModal = document.getElementById('themeModal');
	themeModal.addEventListener('show.bs.modal', function (event) {
		var button = event.relatedTarget;
		var imgSrc = button.getAttribute('data-img');
		var modalImg = themeModal.querySelector('#theme-modal-img');
		modalImg.src = imgSrc;
	});
});
</script>

</x-layout-dashboard>