<label for="message" class="form-label"><?php echo e(__('Message')); ?></label>
<textarea name="message" class="form-control" id="message" required><?php echo e($message ?? ''); ?></textarea>

<label for="footer" class="form-label mt-2"><?php echo e(__('Footer message *optional')); ?></label>
<input type="text" name="footer" class="form-control" id="footer" value="<?php echo e($footer ?? ''); ?>">

<label class="form-label mt-2"><?php echo e(__('Image')); ?> <span class="text-sm text-warning">*<?php echo e(__('Required')); ?></span></label>
<div class="input-group">
    <span class="input-group-btn">
        <a id="image" data-input="thumbnail" data-preview="holder" class="btn btn-primary text-white">
            <i class="fa fa-picture-o"></i> <?php echo e(__('Choose')); ?>

        </a>
    </span>
    <input id="thumbnail" class="form-control" type="text" name="image" value="<?php echo e($image ?? ''); ?>" required>
</div>

<div id="button-area<?php echo e($id); ?>" class="mt-3">
<?php if($buttons): ?>
    <?php $__currentLoopData = $buttons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $butt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $buttonData = $butt->buttonText->displayText ?? null;
        $type = $buttonData->type ?? 'reply';
        $text = $buttonData->displayText ?? '';
    ?>

    <div class="card mb-3 button-block" id="button<?php echo e($id); ?><?php echo e($index); ?>">
        <div class="card-header d-flex justify-content-between align-items-center">
            <strong><?php echo e(__('Button')); ?> <?php echo e($index + 1); ?></strong>
            <a class="remove-button" data-id="<?php echo e($id); ?><?php echo e($index); ?>">
                <i class="icon-base ti tabler-trash icon-sm cursor-pointer"></i>
            </a>
        </div>
        <div class="card-body">
            <div class="form-group mb-2">
                <label class="form-label"><?php echo e(__('Type')); ?></label>
                <select name="button[<?php echo e($index); ?>][type]" class="form-control button-type" data-id="<?php echo e($id); ?><?php echo e($index); ?>" required>
                    <option value="reply" <?php echo e($type == 'reply' ? 'selected' : ''); ?>><?php echo e(__('Reply')); ?></option>
                    <option value="call" <?php echo e($type == 'call' ? 'selected' : ''); ?>><?php echo e(__('Call')); ?></option>
                    <option value="url" <?php echo e($type == 'url' ? 'selected' : ''); ?>><?php echo e(__('URL')); ?></option>
                    <option value="copy" <?php echo e($type == 'copy' ? 'selected' : ''); ?>><?php echo e(__('Copy')); ?></option>
                </select>
            </div>

            <div class="form-group mb-2">
                <label class="form-label"><?php echo e(__('Display Text')); ?></label>
                <input type="text" name="button[<?php echo e($index); ?>][displayText]" class="form-control" value="<?php echo e($text); ?>" required>
            </div>

            <div class="extra-field" id="extra<?php echo e($id); ?><?php echo e($index); ?>">
                <?php if($type === 'url'): ?>
                    <label class="form-label mt-2"><?php echo e(__('URL')); ?></label>
                    <input type="url" name="button[<?php echo e($index); ?>][url]" class="form-control" value="<?php echo e($buttonData->url ?? ''); ?>">
                <?php elseif($type === 'call'): ?>
                    <label class="form-label mt-2"><?php echo e(__('Phone Number')); ?></label>
                    <input type="tel" name="button[<?php echo e($index); ?>][phoneNumber]" class="form-control" value="<?php echo e($buttonData->phoneNumber ?? ''); ?>">
                <?php elseif($type === 'copy'): ?>
                    <label class="form-label mt-2"><?php echo e(__('Copy Text')); ?></label>
                    <input type="text" name="button[<?php echo e($index); ?>][copyCode]" class="form-control" value="<?php echo e($buttonData->copyCode ?? ''); ?>">
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php endif; ?>
</div>

<button type="button" id="add-button<?php echo e($id); ?>" class="btn btn-success btn-sm mt-4"><?php echo e(__('Add Button')); ?></button>

<script>
    let buttonIndex<?php echo e($id); ?> = <?php echo e(count($buttons) ?? 0); ?>;
    const maxButtons = 4;

    $('#add-button<?php echo e($id); ?>').click(function () {
        if (buttonIndex<?php echo e($id); ?> >= maxButtons) {
            toastr.warning("<?php echo e(__('Maximal 4 buttons')); ?>");
            return;
        }

        const index = buttonIndex<?php echo e($id); ?>;
        const label = "<?php echo e(__('Button :x')); ?>".replace(':x', index + 1);

        const html = `
        <div class="card mb-3 button-block" id="button<?php echo e($id); ?>${index}">
            <div class="card-header d-flex justify-content-between align-items-center">
                <strong>${label}</strong>
                <a class="remove-button" data-id="<?php echo e($id); ?>${index}">
                    <i class="icon-base ti tabler-trash icon-sm cursor-pointer"></i>
                </a>
            </div>
            <div class="card-body">
                <div class="form-group mb-2">
                    <label class="form-label"><?php echo e(__('Type')); ?></label>
                    <select name="button[${index}][type]" class="form-control button-type" data-id="<?php echo e($id); ?>${index}" required>
                        <option value="reply"><?php echo e(__('Reply')); ?></option>
                        <option value="call"><?php echo e(__('Call')); ?></option>
                        <option value="url"><?php echo e(__('URL')); ?></option>
                        <option value="copy"><?php echo e(__('Copy')); ?></option>
                    </select>
                </div>

                <div class="form-group mb-2">
                    <label class="form-label"><?php echo e(__('Display Text')); ?></label>
                    <input type="text" name="button[${index}][displayText]" class="form-control" required>
                </div>

                <div class="extra-field" id="extra<?php echo e($id); ?>${index}"></div>
            </div>
        </div>`;

        $('#button-area<?php echo e($id); ?>').append(html);
        buttonIndex<?php echo e($id); ?>++;
    });

    $(document).on('click', '.remove-button', function () {
        const id = $(this).data('id');
        $('#button' + id).remove();
    });

    $(document).on('change', '.button-type', function () {
        const type = $(this).val();
        const id = $(this).data('id');
        const target = $('#extra' + id);
        target.empty();

        if (type === 'url') {
            target.append(`
                <label class="form-label mt-2"><?php echo e(__('URL')); ?></label>
                <input type="url" name="button[${id}][url]" class="form-control" required>
            `);
        } else if (type === 'call') {
            target.append(`
                <label class="form-label mt-2"><?php echo e(__('Phone Number')); ?></label>
                <input type="tel" name="button[${id}][phoneNumber]" class="form-control" required>
            `);
        } else if (type === 'copy') {
            target.append(`
                <label class="form-label mt-2"><?php echo e(__('Copy Text')); ?></label>
                <input type="text" name="button[${id}][copyCode]" class="form-control" required>
            `);
        }
    });
</script>
<script src="<?php echo e(asset('vendor/laravel-filemanager/js/stand-alone-button2.js')); ?>"></script>
<?php /**PATH /home/ccwebhos/wap.ccwebhost.in/resources/themes/vuexy/views/ajax/messages/buttonedit.blade.php ENDPATH**/ ?>